/*------------------------------------------------------------------------------*
 *	File Name: 	ocPFM.h									 						*
 *	Purpose: PFM utility functions, baseline etc							  	*
 *  Creation:	11/11/2005, CPY and Leo and Sandy								*
 *  	Copyright Originlab Corp. 2005, 2006,									*
 *	Modification log	                                                        *
 *	Jack 11/15/2008	ADD_BACK_SHIRLEY_BASELINE									*
 *	Jack 11/17/2008	ADD_BACK_TOUGARD_BASELINE									*
 *------------------------------------------------------------------------------*/      

#ifndef _OCPFM_H
#define _OCPFM_H

#ifdef __AFX_H__
	#ifdef OPFM_DLL
		#define OPFM_API __declspec(dllexport)
	#else
		#define OPFM_API __declspec(dllimport)
	#endif

	#define string 			CString  //DSC 9/26/05 QA70-8113 TEST_DATAID_EXITS_AND_VALID


	#define TreeNode		OCXmlWrapperBase
	#define StringArray		CScriptMocaObject
	#define	IntArray		CScriptMocaObject
	extern "C" {
#else
	#define OPFM_API
	//#pragma dll(oPFM8, header)	// Associate all functions below to oPFM.dll which must be in the OriginC\Originlab\oPFM folder
	#pragma dll(oPFM8)
	#define	IntArray	vector<int>
#endif	//__AFX_H__

/*
//no use in PFM80
#define TOUGAARD_1   1   //R1 R2 B1
#define TOUGAARD_2   2	 //E1 E2 B1
#define TOUGAARD_3   3	 //R1 R2 N0
#define TOUGAARD_4   4	 //E1 E2 N0

#define SHIRLEY_1	1	 //R1 R2 N0
#define SHIRLEY_2	2	 //E1 E2 N0
*/
#define MAX_Factor 200

// for testing only
OPFM_API BOOL opfm_test_sort(double* pData, UINT nPts);


// Comments last updated by Sandy on 19/11/2005
/**	Statistics
	Remarks:
		This function create a baseline for the input data with Tougaard.  
	Keywords:
		baseline, Tougaard
	Example1:
		// Uses the active worksheet. Put data into column 1 as X and column as Y, they should have same size,
		result add a column to store the baseline
		void opfm_tougaard_ex1(double value)
		{
			Worksheet wks = Project.ActiveLayer();
			if(!wks)
				return;
			
			int iCol=wks.AddCol();
			
			if(iCol<0)
				return;
 
			Dataset dsX(wks, 0);
			Dataset dsY(wks, 1);
			Dataset dsOut; 
			dsOut.Attach(wks, iCol);
			
			vector vx = dsX;
			vector vy = dsY;
			
			int nSize;
			nSize=vx.GetSize();
			if(nSize!=vy.GetSize())
				return;

  
			vector vTougardBaseY;
			vTougardBaseY.SetSize(nSize);

			int iMin = 0 ;	 // full range
			int iMax = nSize-1;
			double dHeight = vy[0];
			int  nRet = opfm_tougaard(vx, vy, nSize, iMin, iMax, true, dHeight, vTougardBaseY);        



			
			dsOut.SetSize(nSize);
			dsOut = vTougardBaseY;
		}
	Parameters:
		pDataX=		[input]  the data pointer point to signal X coordinate.
		pDataY=		[input]  the data pointer point to signal Y coordinate.
		uDataSize=	[input]	 size of signal data.
		dStart=		[input]  the Lower Bound index when bIndexOrEnergyInput = true or the lower energy x value when bIndexOrEnergyInput = false
		dEnd=		[input]	 the upper Bound index when bIndexOrEnergyInput = true or the upper energy x value when bIndexOrEnergyInput = false
		base=		[input]	 flag that point to which base height to use. 
		dHeight=	[input]  baseline parameter, when base flag is true, use B0 as the final height
		                     when base flag is false, adjustable parameter method
		pOutY=		[output] the data pointer pointed to baseline y value evaluated at input X
		bIndexOrEnergyInput = [input]  control dStart and dEnd as index input when true or as the energy input when false
	Return:
		0: No error
		-1: Invalid datasize
		-2: Incompatible x col
	SeeAlso:
		
*/
///Jack	11/17/2008	ADD_BACK_TOUGARD_BASELINE
//OPFM_API int opfm_tougaard(double* pDataX, double* pDataY, UINT uDataSize, bool base, double dMinRange, double dMaxRange, double dHeight);
//OPFM_API int opfm_tougaard(double* pDataX, double* pDataY, UINT uDataSize, bool base, double dHeight);
OPFM_API int opfm_tougaard(double* pDataX, double* pDataY, UINT nSize, double dStart, double dEnd, bool base, double finalHeight, double * pOutY, bool bIndexOrEnergyInput);
// base == true for finalHeight method
// base == false for adjustable parameter method
// the input x is assumed in acsending order
///End	ADD_BACK_TOUGARD_BASELINE

// Comments last updated by Sandy on 19/11/2005
/**	Statistics
	Remarks:
		This function create a baseline for the input data with Shirley.  
	Keywords:
		baseline, Shirley
	Example1:
		// Uses the active worksheet. Put data into column 1 as X and column as Y, they should have same size,
		result add a column to store the baseline
		void opfm_shirley_ex1(double value)
		{
			Worksheet wks = Project.ActiveLayer();
			if(!wks)
				return;
			
			int iCol=wks.AddCol();
			
			if(iCol<0)
				return;
 
			Dataset dsX(wks, 0);
			Dataset dsY(wks, 1);
			Dataset dsOut; 
			dsOut.Attach(wks, iCol);
			
			vector vx = dsX;
			vector vy = dsY;
			
			int nSize;
			nSize=vx.GetSize();
			if(nSize!=vy.GetSize())
				return;

			vector vShirleyBaseY;
			vShirleyBaseY.SetSize(nSize);
			
//			int nRet=opfm_shirley(vx, vy, nSize, true, value);
			int iMin = 0 ;  // full range
			int iMax = nSize-1;
			double dHeight = vy[0];
			int nRet=opfm_shirley( vx, vy, nSize, iMin, iMax,  dHeight, vShirleyBaseY);
			
			dsOut.SetSize(nSize);
			dsOut = vShirleyBaseY;

		}
	Parameters:
		pDataX=		[input]  the data pointer point to signal X coordinate.
		pDataY=		[input]  the data pointer point to signal Y coordinate.
		uDataSize=	[input]	 size of signal data.
		dStart=		[input]  the Lower Bound index when bIndexOrEnergyInput = true or the lower energy x value when bIndexOrEnergyInput = false
		dEnd=		[input]	 the upper Bound index when bIndexOrEnergyInput = true or the upper energy x value when bIndexOrEnergyInput = false
		dHeight=	[input]  baseline parameter 
		pOutY=		[output] the data pointer pointed to baseline y value evaluated at input X
		bIndexOrEnergyInput = [input]  control dStart and dEnd as index input when true or as the energy input when false
	Return:
		0: No error 
		<0: Error
	SeeAlso:
		
*/
///Jack	11/15/2008	ADD_BACK_SHIRLEY_BASELINE
//OPFM_API int opfm_shirley(double* pDataX, double* pDataY, UINT uDataSize, bool base, double MinRange, double dMaxRange, double dHeight);
//OPFM_API int opfm_shirley(double* pDataX, double* pDataY, UINT uDataSize, double dHeight);
OPFM_API int opfm_shirley( double* pDataX, double* pDataY, UINT nSize, double dStart, double dEnd,  double dHeight, double * pOutY, bool bIndexOrEnergyInput);
// the input x is assumed in acsending order
///End ADD_BACK_SHIRLEY_BASELINE

// Comments last updated by Sandy on 19/11/2005
/**	Statistics
	Remarks:
		This function create a baseline for the input data with chebyshev.  
	Keywords:
		baseline, chebyshev
	Example1:

	void opfm_chebyshev_ex1()
	{
		Worksheet wks = Project.ActiveLayer();
		if(!wks)
			return;
		
		int iCol=wks.AddCol();
		
		if(iCol<0)
			return;
 
		Dataset dsX(wks, 0);
		Dataset dsY(wks, 1);

		Dataset dsOutY;

		dsOutY.Attach(wks, iCol);
		
		vector vx = dsX;
		vector vy = dsY;
		
		int nSize;
		nSize=vx.GetSize();
		if(nSize!=vy.GetSize())
			return;

		int nRet=opfm_chebyshev(vx, vy, vy.GetSize());


		dsOutY.SetSize(nSize);
		dsOutY = vy;

	}	

	Parameters:
		pDataX=		[input]  the data pointer point to signal X coordinate.
		pDataY=		[modify]  the data pointer point to signal Y coordinate.
		uDataSize=	[input]	 size of signal data.
	
	Return:
	 0: No error
	-1: Invalid datasize

	SeeAlso:
		
*/
OPFM_API int opfm_chebyshev(double* pDataX, double* pDataY, UINT uSize);

#ifdef __AFX_H__
	}
#endif	//__AFX_H__

#endif //_OCPFM_H
